/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block.entity;

import com.google.auto.service.AutoService;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_9297;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import noobanidus.mods.lootr.common.api.BuiltInLootrTypes;
import noobanidus.mods.lootr.common.api.IBrushable;
import noobanidus.mods.lootr.common.api.ILootrBlockEntityConverter;
import noobanidus.mods.lootr.common.api.ILootrType;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.advancement.IContainerTrigger;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import noobanidus.mods.lootr.common.api.data.SimpleLootrInstance;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.integration.digsite_workshop.IModdedBrushItem;
import noobanidus.mods.lootr.common.mixin.accessor.AccessorMixinFallingBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootrBrushableBlockEntity
extends class_2586
implements ILootrBlockEntity,
IBrushable {
    private final SimpleLootrInstance simpleLootrInstance = new SimpleLootrInstance(this::getVisualOpeners, 1);
    @Nullable
    private UUID brushingPlayer;
    @Nullable
    private class_1657 brushingPlayerEntity;
    private int brushCount;
    private long brushCountResetsAtTick;
    private long coolDownEndsAtTick;
    private class_1799 item = class_1799.field_8037;
    @Nullable
    private class_2350 hitDirection;
    @Nullable
    private class_5321<class_52> lootTable;
    private long lootTableSeed;

    public LootrBrushableBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(LootrRegistry.getBrushableBlockEntity(), blockPos, blockState);
    }

    private class_2487 getFallData(class_7225.class_7874 provider) {
        return this.method_58692(provider);
    }

    @Override
    @Nullable
    public IContainerTrigger getTrigger() {
        if (this.method_11010().method_26164(LootrTags.Blocks.SANDS)) {
            return LootrRegistry.getSandTrigger();
        }
        if (this.method_11010().method_26164(LootrTags.Blocks.GRAVELS)) {
            return LootrRegistry.getGravelTrigger();
        }
        return null;
    }

    @Override
    public boolean IBrushable$brush(long l, class_1657 player, class_2350 direction) {
        class_1657 brushingPlayer;
        class_1799 brushItem = this.getBrushItem(player);
        class_1792 class_17922 = brushItem.method_7909();
        if (class_17922 instanceof IModdedBrushItem) {
            IModdedBrushItem moddedBrushItem = (IModdedBrushItem)class_17922;
            this.coolDownEndsAtTick -= 10L - moddedBrushItem.lootr$getBrushingSpeed();
        }
        if ((brushingPlayer = this.getBrushingPlayer()) != null) {
            if (player != brushingPlayer) {
                return false;
            }
            if (!this.hasLootAvailable((class_3222)player)) {
                return false;
            }
        } else {
            if (!this.hasLootAvailable((class_3222)player)) {
                this.brushingPlayer = null;
                this.brushingPlayerEntity = null;
                return false;
            }
            this.brushingPlayerEntity = player;
            this.brushingPlayer = null;
        }
        if (!this.simpleLootrInstance.hasBeenOpened()) {
            this.simpleLootrInstance.setHasBeenOpened();
            this.markChanged();
        }
        if (this.hitDirection == null) {
            this.hitDirection = direction;
        }
        this.brushCountResetsAtTick = l + 40L;
        if (l >= this.coolDownEndsAtTick && this.field_11863 instanceof class_3218) {
            this.coolDownEndsAtTick = l + 10L;
            int i = this.getCompletionState();
            if (++this.brushCount >= 10) {
                this.brushingCompleted(player);
                return true;
            }
            this.field_11863.method_64310(this.method_11016(), this.method_11010().method_26204(), 2);
            int j = this.getCompletionState();
            if (i != j) {
                class_2680 blockState = this.method_11010();
                class_2680 blockState2 = (class_2680)blockState.method_11657((class_2769)class_2741.field_42836, (Comparable)Integer.valueOf(j));
                this.field_11863.method_8652(this.method_11016(), blockState2, 3);
            }
            return false;
        }
        return false;
    }

    private class_1799 getBrushItem(class_1657 player) {
        if (player.method_6047().method_7909() instanceof IModdedBrushItem) {
            return player.method_6047();
        }
        if (player.method_6079().method_7909() instanceof IModdedBrushItem) {
            return player.method_6079();
        }
        return class_1799.field_8037;
    }

    private void brushingCompleted(class_1657 player) {
        if (this.field_11863 != null && this.field_11863.method_8503() != null) {
            this.dropContent(player);
            this.performTrigger((class_3222)player);
            boolean shouldUpdate = false;
            if (!this.hasServerOpened(player)) {
                player.method_7259(LootrRegistry.getLootedStat());
                LootrRegistry.getStatTrigger().trigger((class_3222)player);
            }
            if (this.addOpener(player)) {
                this.performOpen((class_3222)player);
                shouldUpdate = true;
            }
            if (shouldUpdate) {
                this.performUpdate((class_3222)player);
            }
        }
    }

    private void dropContent(class_1657 player) {
        class_1799 theItem;
        if (this.field_11863 != null && this.field_11863.method_8503() != null && !(theItem = this.popItem(player)).method_7960()) {
            double d = class_1299.field_6052.method_17685();
            double e = 1.0 - d;
            double f = d / 2.0;
            class_2350 direction = Objects.requireNonNullElse(this.hitDirection, class_2350.field_11036);
            class_2338 blockPos = this.field_11867.method_10079(direction, 1);
            double g = (double)blockPos.method_10263() + 0.5 * e + f;
            double h = (double)blockPos.method_10264() + 0.5 + (double)(class_1299.field_6052.method_17686() / 2.0f);
            double i = (double)blockPos.method_10260() + 0.5 * e + f;
            class_1542 itemEntity = new class_1542(this.field_11863, g, h, i, theItem.method_7971(this.field_11863.field_9229.method_43048(21) + 10));
            itemEntity.method_18799(class_243.field_1353);
            this.field_11863.method_8649((class_1297)itemEntity);
            this.item = class_1799.field_8037;
        }
    }

    @Override
    public void IBrushable$checkReset() {
        if (this.field_11863 != null) {
            if (this.brushCount != 0 && this.field_11863.method_75260() >= this.brushCountResetsAtTick) {
                int i = this.getCompletionState();
                this.brushCount = Math.max(0, this.brushCount - 2);
                int j = this.getCompletionState();
                if (i != j) {
                    this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_42836, (Comparable)Integer.valueOf(j)), 3);
                }
                this.brushCountResetsAtTick = this.field_11863.method_75260() + 4L;
            }
            if (this.brushCount == 0) {
                this.brushingPlayer = null;
                this.brushingPlayerEntity = null;
                this.hitDirection = null;
                this.brushCountResetsAtTick = 0L;
                this.coolDownEndsAtTick = 0L;
            } else {
                this.field_11863.method_64310(this.method_11016(), this.method_11010().method_26204(), 2);
            }
        }
    }

    private void tryLoadLootTable(class_11368 input) {
        this.lootTable = input.method_71426("LootTable", class_52.field_56684).orElse(null);
        this.lootTableSeed = input.method_71425("LootTableSeed", 0L);
    }

    private void trySaveLootTable(class_11372 output) {
        if (this.lootTable != null) {
            output.method_71468("LootTable", class_52.field_56684, this.lootTable);
            if (this.lootTableSeed != 0L) {
                output.method_71466("LootTableSeed", this.lootTableSeed);
            }
        }
    }

    @Override
    public void setLootTableInternal(class_5321<class_52> lootTable, long seed) {
        this.lootTable = lootTable;
        this.lootTableSeed = seed;
    }

    @Nullable
    public class_1657 getBrushingPlayer() {
        if (this.brushingPlayerEntity != null) {
            if (this.brushingPlayer != null) {
                this.brushingPlayer = null;
            }
            return this.brushingPlayerEntity;
        }
        if (this.brushingPlayer != null && this.field_11863 != null) {
            this.brushingPlayerEntity = this.field_11863.method_18470(this.brushingPlayer);
            this.brushingPlayer = null;
        }
        return null;
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 compoundTag = super.method_16887(provider);
        compoundTag.method_68082("hit_direction", class_2350.field_57037, (Object)this.hitDirection);
        class_1657 player = this.getBrushingPlayer();
        if (player != null) {
            compoundTag.method_67494("brushing_player", class_4844.field_25122, (Object)player.method_5667());
            if (this.item.method_7960()) {
                this.item = this.getItem(player);
            }
            if (!this.item.method_7960()) {
                class_6903 registryops = provider.method_57093((DynamicOps)class_2509.field_11560);
                compoundTag.method_67493("item", class_1799.field_24671, (DynamicOps)registryops, (Object)this.item);
            }
        }
        compoundTag.method_10543(this.simpleLootrInstance.fillUpdateTag(provider, this.field_11863 != null && this.field_11863.method_8608(), this));
        return compoundTag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_39026((class_2586)this, class_2586::method_16887);
    }

    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        this.tryLoadLootTable(input);
        this.hitDirection = input.method_71426("hit_direction", class_2350.field_57037).orElse(null);
        this.brushingPlayer = input.method_71426("brushing_player", class_4844.field_25122).orElse(null);
        this.brushingPlayerEntity = null;
        this.item = this.brushingPlayer != null ? input.method_71426("item", class_1799.field_24671).orElse(class_1799.field_8037) : class_1799.field_8037;
        this.simpleLootrInstance.loadAdditional(input);
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        this.trySaveLootTable(output);
        this.simpleLootrInstance.saveAdditional(output, this.field_11863 != null && this.field_11863.method_8608());
    }

    private int getCompletionState() {
        if (this.brushCount == 0) {
            return 0;
        }
        if (this.brushCount < 3) {
            return 1;
        }
        return this.brushCount < 6 ? 2 : 3;
    }

    @Nullable
    public class_2350 getHitDirection() {
        return this.hitDirection;
    }

    public class_1799 getItem() {
        return this.item;
    }

    public boolean isBrushingPlayer(class_1657 player) {
        class_1657 brushingPlayer = this.getBrushingPlayer();
        return brushingPlayer != null && brushingPlayer == player;
    }

    public class_1799 getItem(class_1657 player) {
        boolean clientSide = player.method_73183().method_8608();
        if (this.isBrushingPlayer(player)) {
            if (clientSide) {
                return this.item;
            }
            if (this.item.method_7960()) {
                ILootrInventory inventory = LootrAPI.getInventory(this, (class_3222)player);
                this.item = inventory == null ? class_1799.field_8037 : inventory.method_5438(0);
            }
        } else {
            this.item = class_1799.field_8037;
        }
        return this.item;
    }

    private class_1799 popItem(class_1657 player) {
        if (player.method_73183().method_8608()) {
            return this.getItem(player);
        }
        class_1799 theItem = this.getItem(player);
        if (!theItem.method_7960()) {
            ILootrInventory inventory = LootrAPI.getInventory(this, (class_3222)player);
            if (inventory != null) {
                inventory.method_5447(0, class_1799.field_8037);
                inventory.method_5431();
            }
            this.item = class_1799.field_8037;
        }
        return theItem;
    }

    @Override
    @Nullable
    public Set<UUID> getClientOpeners() {
        return this.simpleLootrInstance.getClientOpeners();
    }

    @Override
    public boolean isClientOpened() {
        return this.simpleLootrInstance.isClientOpened();
    }

    @Override
    public void setClientOpened(boolean opened) {
        this.simpleLootrInstance.setClientOpened(opened);
    }

    @Override
    public void markChanged() {
        this.method_5431();
        this.markDataChanged();
    }

    @Override
    @Deprecated
    public LootrBlockType getInfoBlockType() {
        return LootrBlockType.CHEST;
    }

    @Override
    public ILootrType getInfoNewType() {
        if (this.method_11010().method_26164(LootrTags.Blocks.SANDS)) {
            return BuiltInLootrTypes.SAND;
        }
        if (this.method_11010().method_26164(LootrTags.Blocks.GRAVELS)) {
            return BuiltInLootrTypes.GRAVEL;
        }
        return BuiltInLootrTypes.CHEST;
    }

    @Override
    @NotNull
    public UUID getInfoUUID() {
        return this.simpleLootrInstance.getInfoUUID();
    }

    @Override
    public String getInfoKey() {
        return this.simpleLootrInstance.getInfoKey();
    }

    @Override
    public boolean hasBeenOpened() {
        return this.simpleLootrInstance.hasBeenOpened();
    }

    @Override
    public boolean isPhysicallyOpen() {
        return (Integer)this.method_11010().method_11654((class_2769)class_2741.field_42836) > 0;
    }

    @Override
    @NotNull
    public class_2338 getInfoPos() {
        return this.method_11016();
    }

    @Override
    @Nullable
    public class_2561 getInfoDisplayName() {
        return null;
    }

    @Override
    @NotNull
    public class_5321<class_1937> getInfoDimension() {
        return this.field_11863.method_27983();
    }

    @Override
    public int getInfoContainerSize() {
        return 1;
    }

    @Override
    @Nullable
    public class_2371<class_1799> getInfoReferenceInventory() {
        return this.simpleLootrInstance.getReferenceInventory();
    }

    @Override
    public boolean isInfoReferenceInventory() {
        return this.simpleLootrInstance.isReferenceInventory();
    }

    @Override
    @Nullable
    public class_5321<class_52> getInfoLootTable() {
        return this.lootTable;
    }

    @Override
    public long getInfoLootSeed() {
        return this.lootTableSeed;
    }

    @Override
    public class_1937 getInfoLevel() {
        return this.field_11863;
    }

    public void method_57569(class_11372 compoundTag) {
        super.method_57569(compoundTag);
        compoundTag.method_71478("LootTable");
        compoundTag.method_71478("LootTableSeed");
        compoundTag.method_71478("LootrId");
    }

    protected void method_57568(class_9473 dataComponentInput) {
        super.method_57568(dataComponentInput);
        class_9297 loot = (class_9297)dataComponentInput.method_58694(class_9334.field_49626);
        if (loot != null && loot.comp_2414() != null) {
            this.lootTable = loot.comp_2414();
            this.lootTableSeed = loot.comp_2415();
        }
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        if (this.lootTable != null) {
            builder.method_57840(class_9334.field_49626, (Object)new class_9297(this.lootTable, this.lootTableSeed));
        }
    }

    public static void fall(class_3218 level, class_2338 blockPos, class_2680 blockState, LootrBrushableBlockEntity brushableBlockEntity) {
        if (LootrAPI.canBrushablesSelfSupport()) {
            return;
        }
        class_1540 fallingBlockEntity = new class_1540(class_1299.field_6089, (class_1937)level);
        double d = (double)blockPos.method_10263() + 0.5;
        double e = blockPos.method_10264();
        double f = (double)blockPos.method_10260() + 0.5;
        ((AccessorMixinFallingBlockEntity)fallingBlockEntity).lootr$setBlockState(blockState.method_28498((class_2769)class_2741.field_12508) ? (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.FALSE) : blockState);
        fallingBlockEntity.field_23807 = true;
        fallingBlockEntity.method_5814(d, e, f);
        fallingBlockEntity.method_18799(class_243.field_1353);
        fallingBlockEntity.field_6014 = d;
        fallingBlockEntity.field_6036 = e;
        fallingBlockEntity.field_5969 = f;
        fallingBlockEntity.field_7194 = brushableBlockEntity.getFallData((class_7225.class_7874)level.method_30349());
        fallingBlockEntity.method_6963(fallingBlockEntity.method_24515());
        fallingBlockEntity.field_7193 = false;
        level.method_8652(blockPos, blockState.method_26227().method_15759(), 3);
        level.method_8649((class_1297)fallingBlockEntity);
    }

    @AutoService(value={ILootrBlockEntityConverter.class})
    public static class DefaultBlockEntityConverter
    implements ILootrBlockEntityConverter<LootrBrushableBlockEntity> {
        @Override
        public ILootrBlockEntity apply(LootrBrushableBlockEntity blockEntity) {
            return blockEntity;
        }

        @Override
        public class_2591<?> getBlockEntityType() {
            return LootrRegistry.getBrushableBlockEntity();
        }
    }
}

